﻿Imports HgCo.WindowsLive.SkyDrive

Public Class frmMain
    Private WithEvents mySkyDrive As New SkyDriveServiceClient()

    Private myBatchMode As Boolean = False
    Private myUploadRunning As Boolean = False
    Private mySourceFileOrFolder As String = ""
    Private myZipFile As String = ""
    Private mySDErrorMessage As String = ""
    Private mySDFileSizeLimit As Long = 50 * 1024 * 1024
    Private myErrorLevel As Integer = 1

    Private myMruListSource As New System.Collections.Specialized.StringCollection
    Private myMruListDestination As New System.Collections.Specialized.StringCollection
    Private myMruMaxEntries As Integer = 8

    ' ******************************************************************************************
    ' Windows-Form-Ereignisroutinen
    ' ******************************************************************************************

    Private Sub frmMain_Load(sender As Object, e As System.EventArgs) Handles Me.Load
        mySkyDrive = Nothing

        With Me
            ' Anwendungsname in Formtitel und...
            .Text = AppTitle
            ' ... Tray-Icon-Titel übernehmen
            .nicIcon.Text = AppTitle
        End With

        ' Wenn höchstens EIN Argument vorhanden (Programm per Doppelklick oder Droppen 
        ' einer Datei gestartet wurde), dann...
        If My.Application.CommandLineArgs.Count < 2 Then
            ' ... Batch-Modus deaktivieren (= GUI sichtbar)
            myBatchMode = False

            ' Einzelnes Argument (sofern vorhanden) in cmbSourceFileOrFolder übernehmen
            If My.Application.CommandLineArgs.Count = 1 Then
                Me.cmbSourceFileOrFolder.Text = My.Application.CommandLineArgs(0)
            End If

            With My.Settings
                ' MRU-Liste MruListSource aus Settings einlesen und... 
                myMruListSource = String2StringCollection(.MruListSource, "*")
                ' ... in cmbSourceFile übertragen
                Call MruUpdateComboBox(Me.cmbSourceFileOrFolder, myMruListSource)

                ' MRU-Liste MruListDestination aus Settings einlesen und... 
                myMruListDestination = String2StringCollection(.MruListDestination, "*")
                ' ... in cmbSDFolder übertragen
                Call MruUpdateComboBox(Me.cmbSDFolder, myMruListDestination)
                ' Wenn cmbSDFolder Elemente enthält, dann...
                If Me.cmbSDFolder.Items.Count > 0 Then
                    ' ... erstes Element (zuletzt eingestellten SkyDrive-Ordner) aktivieren
                    Me.cmbSDFolder.SelectedIndex = 0
                End If

                ' Alle übrigen GUI-Einstellungen aus Settings lesen
                Me.chkZipFileOrFolder.Checked = .chkZipFileOrFolder
                Me.txtZipPassword.Text = .txtZipPassword
                Me.chkReplace.Checked = .chkReplace
                Me.chkDeleteSourceFile.Checked = .chkDeleteSourceFile
            End With

            ' Wenn mindestens ZWEI Argumente vorhanden, dann...
        Else
            ' ... Batch-Modus aktivieren (= GUI unsichtbar)
            myBatchMode = True

            ' Alle Befehlszeilenargumente durchlaufen
            For Each Arg As String In My.Application.CommandLineArgs
                Select Case Arg.ToLower
                    ' Wenn Argument "/Z" ist, dann...
                    Case "/z"
                        ' ... chkZipFileOrFolder aktivieren (komprimieren)
                        Me.chkZipFileOrFolder.Checked = True

                        ' Wenn Argument "/R" ist, dann...
                    Case "/r"
                        ' ... chkReplace aktivieren (nur letzte Version behalten, namensgleiche Datei ersetzen)
                        Me.chkReplace.Checked = True

                        ' Wenn Argument "/D" ist, dann...
                    Case "/d"
                        ' ... chkDeleteSourceFile aktivieren (Quelldatei nach Upload löschen)
                        Me.chkDeleteSourceFile.Checked = True

                        ' Bei jedem anderen Argument...
                    Case Else
                        ' ... prüfen, ob es mit "/P:" beginnt. Wenn ja, dann...
                        If Arg.ToLower.StartsWith("/p:") Then
                            ' ... den Text dahinter in txtPassword übernehmen
                            Me.txtZipPassword.Text = Arg.Substring(3)

                            ' Wenn Argument NICHT mit "/P:" beginnt, dann...
                        Else
                            ' ... zuerst in cmbSourceFile...
                            If Me.cmbSourceFileOrFolder.Text = "" Then
                                Me.cmbSourceFileOrFolder.Text = Arg

                                ' ... und dann in cmbSDFolder übernehmen
                            Else
                                Me.cmbSDFolder.Text = Arg
                            End If
                        End If
                End Select
            Next
        End If

        ' Wenn cmbSDFolder (noch) keinen Inhalt hat, dann...
        If Me.cmbSDFolder.Text = "" Then
            ' ... Vorgabewert übernehmen
            Me.cmbSDFolder.Text = AppTitle
        End If

        ' Control-Status aktualisieren
        Call ControlStatus()

        ' Wenn OK-Button aktiviert ist (weil alle notwendigen Parameter vorhanden sind)
        ' UND Batch-Modus aktiv ist, dann...
        If Me.btnOK.Enabled = True AndAlso myBatchMode = True Then
            ' ... Klick auf OK-Button simulieren (Übertragung starten)
            Call btnOK_Click(Nothing, Nothing)
        End If
    End Sub

    Private Sub cmbSourceFile_TextChanged(sender As System.Object, e As System.EventArgs) Handles cmbSourceFileOrFolder.TextChanged
        ' Control-Status aktualisieren
        Call ControlStatus()
    End Sub

    Private Sub btnSourceFile_Click(sender As System.Object, e As System.EventArgs) Handles btnSourceFileOrFolder.Click
        ' Ordner-und-Datei-Dialog anzeigen
        Dim dlgFolderBrowserPlus As clsFolderBrowserPlus = New clsFolderBrowserPlus()
        With dlgFolderBrowserPlus
            .Title = "Bitte wählen Sie die gewünschte Datei oder den Ordner:"
            .BrowseFor = clsFolderBrowserPlus.BrowseForTypes.FilesAndDirectories
            ' Wenn Dialog mit OK beendet, dann...
            If .ShowDialog(Me) = DialogResult.OK Then
                ' ... gewählten Pfad(namen) in Textfeld übernehmen
                Me.cmbSourceFileOrFolder.Text = .Selected
            End If
        End With
    End Sub

    Private Sub cmbSDFolder_TextChanged(sender As System.Object, e As System.EventArgs) Handles cmbSDFolder.TextChanged
        ' Control-Status aktualisieren
        Call ControlStatus()
    End Sub

    Private Sub chkZipFileOrFolder_CheckedChanged(sender As System.Object, e As System.EventArgs) Handles chkZipFileOrFolder.CheckedChanged
        ' Control-Status aktualisieren
        Call ControlStatus()
    End Sub

    Private Sub txtZipPassword_TextChanged(sender As System.Object, e As System.EventArgs) Handles txtZipPassword.TextChanged
        ' Control-Status aktualisieren
        Call ControlStatus()
    End Sub

    Private Sub txtZipPassword_KeyPress(sender As Object, e As System.Windows.Forms.KeyPressEventArgs) Handles txtZipPassword.KeyPress
        ' Wenn eingetipptes Zeichen kein erlaubtes Kennwortzeichen (aber auch kein Steuerzeichen) ist, dann...
        If Char.IsControl(e.KeyChar) = False And IsValidPassword(e.KeyChar) = False Then
            ' ... Meldung machen
            Call ShowPasswordMessage()
            ' Eingabe verhindern
            e.Handled = True
        End If
    End Sub

    ' Beim Eintritt in das Kennwort-Textfeld...
    Private Sub txtZipPassword_Enter(sender As Object, e As System.EventArgs) Handles txtZipPassword.Enter
        With Me.txtZipPassword
            ' ... Textfeldinhalt im Klartext anzeigen
            .UseSystemPasswordChar = False
            .PasswordChar = Nothing
            ' Alles markieren
            .SelectAll()
        End With
    End Sub

    ' Beim Austritt aus dem Kennwort-Textfeld...
    Private Sub txtZipPassword_Leave(sender As Object, e As System.EventArgs) Handles txtZipPassword.Leave
        With Me.txtZipPassword
            ' ... Textfeldinhalt mit Passwortzeichen verbergen
            .UseSystemPasswordChar = True

            ' Wenn Fokus im Textfeld, dann...
            If .Focused Then
                ' ... Fokus auf nächstes Control
                ' (Control-Wechsel per Tab funktioniert sonst nicht)
                Me.chkReplace.Focus()
            End If
        End With
    End Sub

    Private Sub lnkSettings_LinkClicked(sender As System.Object, e As System.EventArgs) Handles lnkSettings.LinkClicked
        ' Dialogfeld Einstellungen anzeigen
        ShowSettingsDialog()
    End Sub

    Private Sub lnkSkyDrive_LinkClicked(sender As System.Object, e As System.EventArgs) Handles lnkSkyDrive.LinkClicked
        Try
            ' SkyDrive-Webseite öffnen
            Process.Start(modMain.SDInfo)
        Catch ex As Exception
        End Try
    End Sub

    Private Sub lnkInfo_LinkClicked(sender As System.Object, e As System.EventArgs) Handles lnkInfo.LinkClicked
        ' Info-Dialog anzeigen
        Dim DlgInfo As New frmInfo
        With DlgInfo
            .Text = "Info"
            .ShowDialog()
        End With
    End Sub

    Private Sub btnOK_Click(sender As System.Object, e As System.EventArgs) Handles btnOK.Click
        ' Pfadnamen der ZIP-Datei zurücksetzen
        myZipFile = ""
        ' Exit-Code auf Eins setzen
        myErrorLevel = 1

        ' Wenn Anwendung im Batch-Modus, dann...
        If myBatchMode = True Then
            ' ... Form verbergen
            Me.Hide()
        End If

        ' Windows-Live-ID und Kennwort aus Settings lesen
        Dim Username As String = My.Settings.txtLiveID
        Dim Password As String = My.Settings.txtLivePassword
        ' Wenn ID oder Kennwort noch NICHT gespeichert, dann...
        If Username = "" Or Password = "" Then
            ' ... Settings-Dialog anzeigen. Wenn der abgebrochen wurde, dann...
            If ShowSettingsDialog() = DialogResult.Cancel Then
                ' ... Form anzeigen
                Me.Show()
                ' Prozedur verlassen
                Return
            End If
        End If

        ' Doppelte-Datei-ersetzen-Flag auf Status von chkReplace setzen
        Dim ReplaceExistingFileFlag As Boolean = Me.chkReplace.Checked
        ' Verweis auf möglicherweise vorhandene Datei initialisieren
        Dim ExistingFileInfo As WebFileInfo = Nothing
        ' Quelle-löschen-Flag auf Status von chkDeleteSourceFile setzen
        Dim DeleteSourceFlag As Boolean = Me.chkDeleteSourceFile.Checked

        ' Pfadnamen des hochzuladenden Dateisystemobjekts aus cmbSourceFile übernehmen 
        mySourceFileOrFolder = Me.cmbSourceFileOrFolder.Text

        ' Datei oder Ordner? Dass das Objekt existiert, steht bereits fest
        Dim FSOType As FSOType = GetFSOType(mySourceFileOrFolder)
        ' Im Fall eines Ordners...
        If FSOType = modMain.FSOType.Folder Then
            ' ... sicherheitshalber nochmal die Checkbox für die Komprimierung einschalten
            ' (sollte schon der Fall sein)
            Me.chkZipFileOrFolder.Checked = True
        End If

        ' Wenn Komprimierung erwünscht, dann...
        If Me.chkZipFileOrFolder.Checked = True Then
            ' ... Datei/Ordner in ZIP-Datei im Windows-Temp-Ordner komprimieren
            myZipFile = MakeZipFile(mySourceFileOrFolder, _
                My.Computer.FileSystem.SpecialDirectories.Temp, Me.txtZipPassword.Text)
            ' Wenn das nicht geklappt hat, dann...
            If myZipFile = "" Then
                ' ... Fehler melden
                ShowErrorMessage("Fehler beim Anlegen der ZIP-Datei.")

                ' Form anzeigen
                Me.Show()
                ' Prozedur verlassen
                Return

                ' Wenn Komprimierung erfolgreich, dann...
            Else
                ' ... Pfadnamen der erzeugten ZIP-Datei in mySourceFileOrFolder übernehmen
                mySourceFileOrFolder = myZipFile
            End If
        End If

        ' --------------------------------------------------------------------------------
        ' Ab jetzt haben wir es in mySourceFileOrFolder auf jeden Fall mit einer Datei 
        ' (ZIP oder Original) zu tun!
        ' --------------------------------------------------------------------------------

        ' Größe der Datei in Bytes ermitteln
        Dim FileSize As Long = My.Computer.FileSystem.GetFileInfo(mySourceFileOrFolder).Length
        ' Wenn die Dateigröße das SkyDrive-Limit überschreitet, dann...
        If FileSize > mySDFileSizeLimit Then
            ' ... Fehler melden
            ShowErrorMessage("Die Größe der Quelldatei überschreitet das SkyDrive-Limit von " & _
                             Bytes2MBytes(mySDFileSizeLimit) & " MB.")

            ' ZIP-Datei (falls vorhanden) in Papierkorb löschen
            Call CleanZipFile()

            ' Form anzeigen
            Me.Show()
            ' cmbSourceFile markieren
            CMBSelect(Me.cmbSourceFileOrFolder)
            ' Prozedur verlassen
            Return
        End If

        ' Flag für laufenden Upload-Prozess einschalten
        myUploadRunning = True
        ' Control-Status aktualisieren
        Call ControlStatus()

        ' Für neue SkyDrive-Session anmelden (falls nicht schon erledigt)
        If mySkyDrive Is Nothing Then
            mySkyDrive = SDGetNewSession()
        End If

        ' Wenn Anmeldung NICHT geklappt hat, dann...
        If mySkyDrive Is Nothing Then
            ' ... SkyDrive-Fehler melden
            ShowErrorMessage(mySDErrorMessage)

            ' ZIP-Datei (falls vorhanden) in Papierkorb löschen
            Call CleanZipFile()

            ' Flag für laufenden Upload-Prozess wieder ausschalten
            myUploadRunning = False
            ' Control-Status aktualisieren
            Call ControlStatus()

            ' Form anzeigen
            Me.Show()
            ' Statuszeilentext löschen
            Me.tslblInfo.Text = ""
            ' Prozedur verlassen
            Return
        End If

        ' Namen des SkyDrive-Zielordners aus cmbSDFolder übernehmen
        Dim SDFolderName As String = Me.cmbSDFolder.Text
        ' WebFolderInfo-Objekt für SkyDrive-Ordner holen 
        ' (und diesen vorher anlegen, falls er nicht existiert)
        Dim SDFolderInfo As WebFolderInfo = SDGetFolderInfo(SDFolderName)

        ' Wenn SkyDrive-Ordner (noch) NICHT existiert, dann...
        If SDFolderInfo Is Nothing Then
            ' ... SkyDrive-Fehler melden
            ShowErrorMessage(mySDErrorMessage)

            ' ZIP-Datei (falls vorhanden) in Papierkorb löschen
            Call CleanZipFile()

            ' Flag für laufenden Upload-Prozess wieder ausschalten
            myUploadRunning = False
            ' Control-Status aktualisieren
            Call ControlStatus()

            ' Form anzeigen
            Me.Show()
            ' Prozedur verlassen
            Return

            ' Wenn SkyDrive-Ordner existiert und...
        Else
            ' ... Doppelte-Datei-ersetzen-Flag gesetzt ist, dann...
            If ReplaceExistingFileFlag = True Then
                ' ... Verweis auf mögliche namensgleiche Datei holen
                ExistingFileInfo = SDGetFileInfo(SDFolderInfo, _
                    My.Computer.FileSystem.GetName(mySourceFileOrFolder))
                ' Wenn namensgleiche Datei existiert, dann...
                If ExistingFileInfo IsNot Nothing Then
                    ' ... neuen Namen (mit eindeutigem, zeitabhängigen Prefix) dafür festlegen
                    Dim NewName As String = "%" & Now.Ticks.ToString & "%" & ExistingFileInfo.Name

                    Try
                        ' Datei entsprechend umbenennen
                        mySkyDrive.RenameWebFolderItem(ExistingFileInfo, NewName)
                        ' Statusmeldung
                        ShowStatus("Vorhandene Datei umbenannt", ToolTipIcon.Info)

                        ' Im Fehlerfall...
                    Catch ex As OperationFailedException
                        ' ... Fehler nur per Statusmeldung anzeigen
                        ShowStatus(ex.Message, ToolTipIcon.Warning)
                        ' Verweis auf namensgleiche Datei löschen
                        ExistingFileInfo = Nothing
                    End Try
                End If
            End If
        End If

        ' Beginn des Uploads melden
        ShowStatus("Upload gestartet...", ToolTipIcon.Info)

        Try
            ' Upload(durchführen)
            mySkyDrive.UploadWebFile(mySourceFileOrFolder, SDFolderInfo)

            ' Wenn namensgleiche (und erfolgreich umbenannte) Datei existiert, dann...
            If ExistingFileInfo IsNot Nothing Then
                Try
                    ' ... diese jetzt löschen
                    mySkyDrive.DeleteWebFile(ExistingFileInfo)
                    ' Statusmeldung
                    ShowStatus("Vorhandene Datei ersetzt", ToolTipIcon.Info)

                    ' Im Fehlerfall...
                Catch ex As OperationFailedException
                    ' ... Fehler nur per Statusmeldung anzeigen
                    ShowStatus(ex.Message, ToolTipIcon.Warning)
                End Try
            End If

            ' Wenn Quelle-löschen-Flag gesetzt, dann...
            If DeleteSourceFlag = True Then
                ' ... Quelldatei-/ordner löschen
                Call CleanSourceFileOrFolder()
            End If

            ' Wenn Anwendung NICHT im Batch-Modus, dann...
            If myBatchMode = False Then
                ' ... Quelldatei/-ordner in MRU-Liste speichern
                SaveToMruList(myMruListSource, IIf(myZipFile > "", Me.cmbSourceFileOrFolder.Text, _
                                                   mySourceFileOrFolder), myMruMaxEntries)
                ' cmbSourceFile aktualisieren
                Call MruUpdateComboBox(Me.cmbSourceFileOrFolder, myMruListSource)

                ' mySDFolderName in MRU-Liste speichern
                SaveToMruList(myMruListDestination, SDFolderName, myMruMaxEntries)
                ' cmbSDFolder aktualisieren
                Call MruUpdateComboBox(Me.cmbSDFolder, myMruListDestination)

                ' MRU-Listen und andere GUI-Einstellungen in Settings speichern
                With My.Settings
                    .MruListSource = StringCollection2String(myMruListSource, "*")
                    .MruListDestination = StringCollection2String(myMruListDestination, "*")
                    .chkZipFileOrFolder = Me.chkZipFileOrFolder.Checked
                    .txtZipPassword = Me.txtZipPassword.Text
                    .chkReplace = Me.chkReplace.Checked
                    .chkDeleteSourceFile = Me.chkDeleteSourceFile.Checked
                    .Save()
                End With
            End If

            ' Inhalt von cmbSourceFile löschen
            Me.cmbSourceFileOrFolder.Text = ""
            CMBSelect(Me.cmbSourceFileOrFolder)

            ' Erfolg melden
            ShowStatus("Upload erfolgreich!", ToolTipIcon.Info)

            ' Exit-Code auf Null setzen
            myErrorLevel = 0

            ' Wenn Fehler beim Upload aufgetreten sind, dann...
        Catch ex As OperationFailedException
            ' ... Fehler melden
            ShowErrorMessage(ex.Message)

            ' Form anzeigen
            Me.Show()
            ' Prozedur verlassen
            Return

            ' Auf jeden Fall...
        Finally
            ' ... Flag für laufenden Upload-Prozess wieder ausschalten
            myUploadRunning = False
            ' Control-Status aktualisieren
            Call ControlStatus()

            ' ZIP-Datei (falls vorhanden) in Papierkorb löschen
            Call CleanZipFile()
        End Try

        ' Wenn Anwendung im Batch-Modus, dann...
        If myBatchMode = True Then
            ' ... Form schließen
            Me.Close()
        End If
    End Sub

    Private Sub btnCancel_Click(sender As System.Object, e As System.EventArgs) Handles btnCancel.Click
        ' Wenn Upload läuft, dann...
        If myUploadRunning = True Then
            ' ... fragen, ob User wirklich abbrechen will. Wenn Nein, dann...
            If MessageBox.Show("Upload wirklich abbrechen?", AppTitle, MessageBoxButtons.YesNo, _
                               MessageBoxIcon.Exclamation) = Windows.Forms.DialogResult.No Then
                ' ... Prozedur verlassen
                Return
            End If
        End If

        ' Form schließen
        Me.Close()
    End Sub

    Private Sub frmMain_FormClosed(sender As Object, e As System.Windows.Forms.FormClosedEventArgs) Handles Me.FormClosed
        ' Tray-Icon aufräumen (!!!)
        nicIcon.Dispose()

        ' Letzten Exit-Code übergeben
        Environment.Exit(myErrorLevel)
    End Sub

    Private Sub nicIcon_Click(sender As Object, e As System.EventArgs) Handles nicIcon.Click
        ' Wenn Form verborgen, dann sichtbar machen (und umgekehrt)
        Me.Visible = Not Me.Visible
    End Sub

    '  ******************************************************************************************
    '  7-Zip-Routinen
    '  ******************************************************************************************

    Private Function MakeZipFile(SourceFileOrFolder As String, DestinationFolder As String, Password As String) As String
        ' Pfadnamen der Zip-Datei bilden
        Dim ZipFile As String = My.Computer.FileSystem.CombinePath( _
            DestinationFolder, My.Computer.FileSystem.GetName(SourceFileOrFolder) & ".zip")

        ' ProcessStart-Infos definieren
        Dim psi As New ProcessStartInfo
        With psi
            ' Pfadname der 7-Zip-Programmdatei 
            .FileName = GetSevenZipPathName()
            ' Argumente nach 7-Zip-Syntax
            .Arguments = "a " & SetBrackets(ZipFile) & " " & SetBrackets(SourceFileOrFolder) _
                & IIf(Password > "", " -p" & SetBrackets(Password), "")
            ' Konsolenfenster bei der Ausführung verbergen
            .WindowStyle = ProcessWindowStyle.Hidden
        End With

        ' Cursor Sanduhr
        Me.Cursor = Cursors.WaitCursor
        ' Statusmeldung
        ShowStatus("Komprimierung...", ToolTipIcon.Info)

        Try
            ' Prozess starten und...
            Dim SevenZipProcess As Process = Process.Start(psi)
            ' ... auf dessen Ende warten
            SevenZipProcess.WaitForExit()

            ' Wenn 7-Zip einen (ernsten) Fehler meldet oder die Zip-Datei nicht existiert, dann... 
            If SevenZipProcess.ExitCode > 1 Or My.Computer.FileSystem.FileExists(ZipFile) = False Then
                ' ... Pfadnamen der Zip-Datei löschen
                ZipFile = ""

                ' Ansonsten...
            Else
                ' ... Statusmeldung über Erfolg
                ShowStatus("Komprimierung durchgeführt", ToolTipIcon.Info)
            End If

            ' Im Fehlerfall...
        Catch ex As Exception
            ' ... Pfadnamen der Zip-Datei löschen
            ZipFile = ""

            ' Auf jeden Fall...
        Finally
            ' ... Cursor normalisieren
            Me.Cursor = Cursors.Default
        End Try

        ' Pfadnamen der Zip-Datei zurückgeben
        Return ZipFile
    End Function

    Private Sub ShowPasswordMessage()
        ' Kennworthinweis anzeigen
        MessageBox.Show("Das Kennwort darf nur Zeichen des englischen Alphabets, Ziffern " & _
                        "und folgende Sonderzeichen enthalten: " & PWSPECIALCHARS, _
                        AppTitle, MessageBoxButtons.OK, MessageBoxIcon.Information)
    End Sub

    ' ******************************************************************************************
    ' SkyDrive-Routinen
    ' ******************************************************************************************

    Private Function SDGetNewSession() As SkyDriveServiceClient
        Dim NewSession As SkyDriveServiceClient = Nothing

        ' User-Namen und Kennwort aus Settings lesen
        Dim Username As String = My.Settings.txtLiveID
        Dim Password As String = My.Settings.txtLivePassword

        ' Cursor Sanduhr
        Me.Cursor = Cursors.WaitCursor
        ' Statusmeldung
        ShowStatus("Anmeldung...", ToolTipIcon.Info)

        Try
            ' SkyDriveServiceClient initialisieren
            NewSession = New SkyDriveServiceClient
            With NewSession
                ' Log-On durchführen
                .LogOn(Username, Password)
                ' Timeout abschalten!!!
                .Timeout = -1
            End With

            ' Statusmeldung
            ShowStatus("Anmeldung erfolgreich", ToolTipIcon.Info)
            ' Anmeldestatus in Titelleiste anzeigen
            Me.Text = AppTitle & " (angemeldet)"

            ' Im Fehlerfall...
        Catch ex As LogOnFailedException
            ' ... SkyDrive-Fehlermeldung merken
            mySDErrorMessage = ex.Message

            ' NewSession auf Nothing setzen, da sonst ein Verweis auf
            ' eine ungültige Session zurückgegeben wird
            NewSession = Nothing

            ' Auf jeden Fall...
        Finally
            ' ... Cursor normalisieren
            Me.Cursor = Cursors.Default
        End Try

        ' NewSession zurückgeben
        Return NewSession
    End Function

    Private Function SDGetFolderInfo(SDFolderName As String) As WebFolderInfo
        Dim FolderInfo As WebFolderInfo = Nothing

        ' Cursor Sanduhr
        Me.Cursor = Cursors.WaitCursor

        Try
            ' Alle SykDrive-Root-Folder durchlaufen
            For Each Folder As WebFolderInfo In mySkyDrive.ListRootWebFolders
                ' Wenn ein Ordner mit dem gewünschten Namen dabei ist, dann...
                If Folder.Name.ToLower = SDFolderName.ToLower Then
                    ' ... Verweis darauf speichern und...
                    FolderInfo = Folder
                    ' ... Schleife verlassen
                    Exit For
                End If

                ' Anwendungs-Ereignisse verarbeiten
                Application.DoEvents()
            Next

            ' Wenn Ordner nicht gefunden, dann...
            If FolderInfo Is Nothing Then
                ' ... neu anlegen
                FolderInfo = mySkyDrive.CreateRootWebFolder(SDFolderName, _
                    WebFolderCategoryType.Documents, WebFolderItemShareType.Private)

                ' Statusmeldung
                ShowStatus("SkyDrive-Ordner " & SDFolderName & " angelegt", ToolTipIcon.Info)
            End If

            ' Im Fehlerfall...
        Catch ex As OperationFailedException
            ' ... SkyDrive-Fehlermeldung merken
            mySDErrorMessage = ex.Message

            ' Auf jeden Fall...
        Finally
            ' ... Cursor normalisieren
            Me.Cursor = Cursors.Default
        End Try

        ' Ordnerverweis zurückgeben
        Return FolderInfo
    End Function

    Private Function SDGetFileInfo(SDFolderInfo As WebFolderInfo, FileName As String) As WebFileInfo
        Dim FileInfo As WebFileInfo = Nothing

        ' Cursor Sanduhr
        Me.Cursor = Cursors.WaitCursor

        Try
            ' Alle Elemente im angegebenen SkyDrive-Ordner durchlaufen
            For Each Item As WebFileInfo In mySkyDrive.ListSubWebFolderItems(SDFolderInfo)
                Try
                    ' Wenn eine Datei mit dem gewünschten Namen dabei ist, dann...
                    If Item.ItemType = WebFolderItemType.File AndAlso Item.Name.ToLower = FileName.ToLower Then
                        ' ... Verweis darauf speichern und...
                        FileInfo = Item
                        ' ... Schleife verlassen
                        Exit For
                    End If
                Catch ex As Exception
                End Try

                ' Anwendungs-Ereignisse verarbeiten
                Application.DoEvents()
            Next

            ' Im Fehlerfall...
        Catch ex As OperationFailedException
            ' ... SkyDrive-Fehlermeldung merken
            mySDErrorMessage = ex.Message

            ' Auf jeden Fall...
        Finally
            ' ... Cursor normalisieren
            Me.Cursor = Cursors.Default
        End Try

        ' Dateiverweis zurückgeben
        Return FileInfo
    End Function

    ' ******************************************************************************************
    ' SkyDrive-Ereignisroutinen
    ' ******************************************************************************************

    Private Sub srvSkyDrive_UploadWebFileProgressChanged(sender As Object, e As UploadWebFileProgressChangedEventArgs) Handles mySkyDrive.UploadWebFileProgressChanged
        ' Wenn Form sichtbar ist, dann...
        If Me.Visible = True Then
            ' ... Upload-Fortschritt über Progressbar anzeigen
            Me.pgbTotal.Value = e.ProgressPercentage
            Me.Update()
            Me.lblTotal.Text = e.ProgressPercentage.ToString & " %"

            ' Wenn Form unsichtbar ist, dann...
        Else
            ' ... Upload-Fortschritt über Tray-Icon-Sprechblase anzeigen
            ShowBalloon(My.Computer.FileSystem.GetName(mySourceFileOrFolder) _
                & " " & e.ProgressPercentage.ToString & " %", ToolTipIcon.Info, 1)
        End If

        ' ContextSwitch-Deadlock verhindern!!!
        Application.DoEvents()
    End Sub

    ' ******************************************************************************************
    ' Sonstige Routinen
    ' ******************************************************************************************

    Private Sub CleanZipFile()
        Try
            ' Wenn ZIP-Datei existiert, dann...
            If My.Computer.FileSystem.FileExists(myZipFile) = True Then
                ' ... diese in Papierkorb löschen
                My.Computer.FileSystem.DeleteFile(myZipFile, FileIO.UIOption.OnlyErrorDialogs, _
                                                  FileIO.RecycleOption.SendToRecycleBin)
            End If
        Catch ex As Exception
        End Try
    End Sub

    Private Sub CleanSourceFileOrFolder()
        Dim Delinquent As String

        ' Wenn Komprimierung durchgeführt, dann...
        If myZipFile > "" Then
            ' ... Pfadnamen des Delinquenten aus cmbSourceFileOrFolder (= ursprüngliche 
            ' Datei/Ordner) übernehmen
            Delinquent = Me.cmbSourceFileOrFolder.Text

            ' Wenn KEINE Komprimierung durchgeführt, dann...
        Else
            ' ... den Pfadnamen aus mySourceFileOrFolder übernehmen
            Delinquent = mySourceFileOrFolder
        End If

        Try
            ' Ist Delinquent Datei oder Ordner?
            Dim FSOType As FSOType = GetFSOType(Delinquent)
            ' Im Falle einer Datei...
            If FSOType = FSOType.File Then
                ' ... diese in Papierkorb löschen
                My.Computer.FileSystem.DeleteFile(Delinquent, FileIO.UIOption.OnlyErrorDialogs, _
                                                  FileIO.RecycleOption.SendToRecycleBin)

                ' Im Falle eines Ordners...
            ElseIf FSOType = modMain.FSOType.Folder Then
                ' ... diesen in Papierkorb löschen
                My.Computer.FileSystem.DeleteDirectory(Delinquent, FileIO.UIOption.OnlyErrorDialogs, _
                                                       FileIO.RecycleOption.SendToRecycleBin)
            End If

            ' Statusmeldung
            ShowStatus("Quelldatei/-ordner gelöscht", ToolTipIcon.Info)

            ' Im Fehlerfall...
        Catch ex As Exception
            ' ... Fehler nur per Statusmeldung anzeigen
            ShowStatus(ex.Message, ToolTipIcon.Warning)
        End Try
    End Sub

    Private Function Bytes2MBytes(Bytes As Long) As Integer
        Return (Bytes / 1024) / 1024
    End Function

    Private Sub CMBSelect(ComboBox As ComponentFactory.Krypton.Toolkit.KryptonComboBox)
        With ComboBox
            .SelectAll()
            .Focus()
        End With
    End Sub

    Private Sub ShowErrorMessage(Text As String)
        ' Gewünschte Nachricht per Dialogfeld anzeigen
        MessageBox.Show(Text, AppTitle, MessageBoxButtons.OK, MessageBoxIcon.Error)
    End Sub

    Private Sub ShowStatus(Text As String, Icon As ToolTipIcon)
        ' Wenn Form sichtbar ist, dann...
        If Me.Visible = True Then
            ' ... Statusmeldung per Statusbar anzeigen
            Me.tslblInfo.Text = Text
            Me.Update()

            ' Wenn Form unsichtbar ist, dann...
        Else
            ' ... Statusmeldung per Tray-Icon-Sprechblase anzeigen
            ShowBalloon(Text, Icon, 5)
        End If
    End Sub

    Private Sub ShowBalloon(Text As String, Icon As ToolTipIcon, Seconds As Integer)
        ' Wenn Meldung eine Fehlermeldung ist, dann...
        If Icon = ToolTipIcon.Error Then
            ' ... System-Sound "Exclamation" abspielen
            My.Computer.Audio.PlaySystemSound(Media.SystemSounds.Exclamation)
        End If

        ' Tray-Icon-Sprechblase konfigurieren
        With Me.nicIcon
            .Text = AppTitle
            .BalloonTipTitle = AppTitle
            .BalloonTipText = Text
            .BalloonTipIcon = Icon
            .ShowBalloonTip(1000 * Seconds)
        End With
    End Sub

    Private Function ShowSettingsDialog() As DialogResult
        Dim Result As DialogResult

        ' frmSettings als Dialogfeld anzeigen
        Dim DlgSettings As New frmSettings
        With DlgSettings
            .Text = "Einstellungen"
            Result = .ShowDialog()

            ' Wenn Dialog mit OK beendet wurde (neue Anmeldedaten), dann...
            If Result = Windows.Forms.DialogResult.OK Then
                ' ... SkyDrive-Session zurücksetzen (damit neues Logon erfolgt)
                mySkyDrive = Nothing
                ' Form-Titel ebenfalls zurücksetzen
                Me.Text = AppTitle
            End If
        End With

        ' Dialogergebnis zurückgeben
        Return Result
    End Function

    Private Sub ControlStatus()
        With Me
            ' Typ des in cmbSourceFileOrFolder enthaltenen Dateisystemobjekts ermitteln
            Dim FSOType As FSOType = GetFSOType(.cmbSourceFileOrFolder.Text)
            ' Ist ZIP-Kennwort gültig?
            Dim PasswordValid As Boolean = IsValidPassword(.txtZipPassword.Text)

            ' Controls (de)aktivieren, je nachdem, ob Upload läuft oder nicht 
            .cmbSourceFileOrFolder.Enabled = Not myUploadRunning
            .btnSourceFileOrFolder.Enabled = Not myUploadRunning
            .cmbSDFolder.Enabled = Not myUploadRunning

            .grpOptions.Enabled = Not myUploadRunning
            ' chkZipFileOrFolder aktivieren, wenn Dateisystemobjekt ein Ordner ist
            If FSOType = modMain.FSOType.Folder Then
                .chkZipFileOrFolder.Checked = True
            End If
            .lblPassword.Enabled = .chkZipFileOrFolder.Checked
            .txtZipPassword.Enabled = .chkZipFileOrFolder.Checked

            .grpProgress.Enabled = myUploadRunning

            .lnkSettings.Enabled = Not myUploadRunning
            .lnkSkyDrive.Enabled = Not myUploadRunning
            .lnkInfo.Enabled = Not myUploadRunning

            ' OK-Button nur aktivieren, wenn ...
            ' - ... kein Upload läuft und... 
            ' - ... cmbSourceFileOrFolder eine gültige Datei/Ordner enthält und...
            ' - ... cmbSDFolder eine beliebige Zielordnerangabe enthält und...
            ' - ... txtPassword ein gültiges (oder gar kein) Kennwort enthält
            .btnOK.Enabled = Not myUploadRunning AndAlso _
                FSOType <> FSOType.NotFound AndAlso _
                .cmbSDFolder.Text > "" AndAlso _
                PasswordValid = True

            ' .btnCancel.Enabled = Not myUploadRunning

            ' Wenn Upload läuft, dann...
            If myUploadRunning = True Then
                ' ... Cursor Sanduhr
                ' .Cursor = Cursors.WaitCursor

                ' Wenn Upload NICHT läuft, dann...
            Else
                ' ... normaler Cursor
                ' .Cursor = Cursors.Default

                ' ProgressBar zurücksetzen
                .pgbTotal.Value = 0
                .lblTotal.Text = "0 %"

                ' Wenn ZIP-Kennwort ungültig, dann Fehler via Statusbar melden
                If PasswordValid = False Then
                    .tslblInfo.Text = "Ungültiges Kennwort!"
                End If

                ' Wenn Datei/Ordner nicht zu finden, dann Fehler via Statusbar melden
                If FSOType = modMain.FSOType.NotFound And Me.cmbSourceFileOrFolder.Text > "" Then
                    .tslblInfo.Text = "Quelldatei/-ordner nicht gefunden!"
                End If

                ' Wenn beides korrekt ist, dann...
                If PasswordValid = True And FSOType <> modMain.FSOType.NotFound Then
                    ' ... vorhandene Statusmeldungen löschen
                    .tslblInfo.Text = ""
                End If
            End If
        End With
    End Sub

End Class
